/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.dao.impl.ModelDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.ModelVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityfolder.ActivityFolder;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.common.SCTTextField;
import com.quantumdata.sct.gui.wizard.IBOHandler;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;

public class ModelGeneralInformationFolder
extends ActivityFolder
implements IBOHandler {
    private SCTTextField modelnumberTextField;
    private SCTTextField modelnameTextField;
    private SCTTextField mftnameTextField;
    private SCTTextField descTextField;
    private ModelVO modelVO;
    private SCTTextField upcTF;
    private SCTTextField partNumberTF;

    public ModelGeneralInformationFolder(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI, "General Information");
        this.init();
    }

    private void init() {
        SCTPanel sCTPanel = new SCTPanel();
        BoxLayout boxLayout = new BoxLayout(sCTPanel, 1);
        sCTPanel.setLayout(boxLayout);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        SCTLabel sCTLabel = new SCTLabel("Manufacturer");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        this.mftnameTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.mftnameTextField, gridBagConstraints);
        sCTPanel2.add(this.mftnameTextField);
        SCTLabel sCTLabel2 = new SCTLabel("Series");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints);
        sCTPanel2.add(sCTLabel2);
        this.modelnameTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.modelnameTextField, gridBagConstraints);
        sCTPanel2.add(this.modelnameTextField);
        SCTLabel sCTLabel3 = new SCTLabel("Model Number");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel3, gridBagConstraints);
        sCTPanel2.add(sCTLabel3);
        this.modelnumberTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.modelnumberTextField, gridBagConstraints);
        sCTPanel2.add(this.modelnumberTextField);
        SCTLabel sCTLabel4 = new SCTLabel("Part Number");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel4, gridBagConstraints);
        sCTPanel2.add(sCTLabel4);
        this.partNumberTF = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.partNumberTF, gridBagConstraints);
        sCTPanel2.add(this.partNumberTF);
        SCTLabel sCTLabel5 = new SCTLabel("UPC");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel5, gridBagConstraints);
        sCTPanel2.add(sCTLabel5);
        this.upcTF = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.upcTF, gridBagConstraints);
        sCTPanel2.add(this.upcTF);
        SCTLabel sCTLabel6 = new SCTLabel("Description");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(sCTLabel6, gridBagConstraints);
        sCTPanel2.add(sCTLabel6);
        this.descTextField = new SCTTextField(20);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.descTextField, gridBagConstraints);
        sCTPanel2.add(this.descTextField);
        sCTPanel.add(sCTPanel2);
        this.add(sCTPanel);
    }

    private void populateUI() {
        if (this.modelVO != null) {
            this.modelnameTextField.setText(this.modelVO.getName());
            this.modelnumberTextField.setText(this.modelVO.getNumber());
            this.mftnameTextField.setText(this.modelVO.getManufacturer());
            this.descTextField.setText(this.modelVO.getDescription());
            this.partNumberTF.setText(this.modelVO.getPartNumber());
            this.upcTF.setText(this.modelVO.getUpc());
        }
    }

    private void populateObject() {
        if (this.modelVO != null && this.modelVO.isUpdateable()) {
            this.modelVO.setDirty(true);
            this.modelVO.setName(this.modelnameTextField.getText());
            this.modelVO.setNumber(this.modelnumberTextField.getText());
            this.modelVO.setManufacturer(this.mftnameTextField.getText());
            this.modelVO.setDescription(this.descTextField.getText());
            this.modelVO.setPartNumber(this.partNumberTF.getText());
            this.modelVO.setUpc(this.upcTF.getText());
        }
    }

    public void preSelect() {
        String string = SCTSelection.instance().getModelID();
        try {
            if (string != null) {
                ModelDAO modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
                IPersistable iPersistable = modelDAO.read(string);
                this.modelVO = (ModelVO)iPersistable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.populateUI();
        SCTSelection.instance().getIBODialog().setCurrentHandler(this);
    }

    private void updateModel() {
        this.populateObject();
        MessageOptionPane messageOptionPane = new MessageOptionPane();
        try {
            ModelDAO modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
            modelDAO.update(this.modelVO);
            MessageOptionPane.ShowMessage(this.getMainWindow(), "Sucessfully Updated....", "Update");
        }
        catch (Exception exception) {
            MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "Model could not be Updated....", "Update");
            exception.printStackTrace();
        }
    }

    public String handleAction(short s) throws Exception {
        if (s == 2) {
            this.updateModel();
        }
        return null;
    }

    public boolean isEnabled(short s) {
        return s == 2 && this.modelVO != null && this.modelVO.isUpdateable();
    }
}

